function [str] = dt_num2str(num)
%[str] = dt_num2str(num)
%convert the given number to data type name
%according to Analyze data format.
%Input:
% num: a integer. Currently supported values are
%      0,1,2,4,8,16,32,64,128 and 255.
%Output:
% str: data type name
%
%20040318, jdlee
%

switch num,
case 0,   str = 'DT_UNKNOWN';
case 1,   str = 'DT_BINARY';
case 2,   str = 'uchar';
case 4,   str = 'int16';
case 8,   str = 'int32';
case 16,  str = 'float';
case 32,  str = 'complex';
case 64,  str = 'double';
case 128, str = 'DT_RGB';
case 255, str = 'DT_ALL';
otherwise, error('unknow input value');
end

return